#!/bin/bash

# reads rebootNodes and passes to rpower
# rpower resets hung nodes

# Allowed node list:
readMe='rebootNodes'
user=$(head -1 ./rebootNodes)
sed '1d' $readMe > 'nodes.txt'
xcatFile='nodes.txt'
recList="resops@broadinstitute.org,scs@broadinstitute.org,$user@broadinstitute.org"
while read line
do
    rpower $line boot
done < $xcatFile

rbNR=`cat  $xcatFile`
mail -s "Rescomp Nodes Rebooted" $recList << EOF
The following  nodes:
$rbNR
have been rebooted as requested by $user.
EOF

# remove file so we don't re-read
# and accidentally reboot again.
for f in $xcatFile $readMe
do
  rm -r $f
done